function Form(name, fields)
{
	
}

$(function()
{
	// File input
	$('input.file').each(function()
	{
		var $this = $(this).hide(), url = $this.attr('url');
		
		$this.removeAttr('url');
		
		var $input = $('<input class="text file" type="text" name="url_'+this.name+'" value="'+url+'"/>').insertAfter($this);
		var $browse = $('<a class="file"/a>').insertAfter($this);
		
		$this.change(function()
		{
			$input.val($this.val().replace('C:\\fakepath\\', ''));
		});
		
		$input.change(function()
		{
			if($input.val().substr(0, 7) === 'http://' || $input.val().substr(0, 8) === 'https://')
			{
				hosting = false;
			}
		});
		
		$browse.click(function()
		{
			$this.click();
		});
		
		if(!window.FileReader)
		{
			$this.parent().css('position', 'relative');
			
			$this.show().css(
			{
				'position': 'absolute',
				'left': '165px',
				'width': '36px',
				'height': '36px',
				'opacity': '0',
				'cursor': 'pointer'
			});
			
			$this.hover(function()
			{
				$browse.addClass('hover');
			}, function()
			{
				$browse.removeClass('hover');
			});
		}
	});
	
	// Checkbox
	$('input.checkbox').each(function()
	{
		var $this = $(this), $checkbox = $('<a class="checkbox"/>');
		
		if($this.attr('checked') === 'checked')
		{
			$checkbox.addClass('checked');
		}
		
		$checkbox.insertBefore($this).click(function()
		{
			if($checkbox.toggleClass('checked').hasClass('checked'))
			{
				$this.attr('checked', 'checked');
			} else
			{
				$this.removeAttr('checked');
			}
		});
		
		$this.removeClass('checkbox').hide();
		
		$.extend($checkbox,
		{
			'check': function()
			{
				$this.attr('checked', 'checked');
				
				$checkbox.addClass('checked');
			},
			'uncheck': function()
			{
				$this.removeAttr('checked');
				
				$checkbox.removeClass('checked');
			}
		});
	});
	
	// Placeholders
	if(!('placeholder' in document.createElement('input')))
	{
		$('input.text[placeholder!=]').each(function()
		{
			var $this = $(this), placeholder = $this.attr('placeholder'), type = $this.attr('type'), holding;
			
			if($this.val() == '')
			{
				holding = true;
				
				$this.val(placeholder).addClass('placeholder');
			} else
			{
				holding = false;
			}
			
			$this.focus(function()
			{
				if(holding)
				{
					holding = false;
					
					$this.val('').removeClass('placeholder');
				}
			});
			
			$this.blur(function()
			{
				if($this.val() == '')
				{
					holding = true;
					
					$this.val(placeholder).addClass('placeholder');
				}
			});
		});
	}
});